<?php

namespace Astreya\TaskSystem\Console\Commands;

use Astreya\TaskSystem\Models\QueuedTask;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;

class CleanTasksCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:clean {type} {--hours=1} {--all}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Запуск чистки задач';

    protected string $type;

    public function handle(): int
    {
        $this->type = (string)$this->argument('type');
        $this->info("Запуск процесса для чистки задач типа $this->type");

        $hours = intval($this->option('hours'));

        $task_count = QueuedTask::where('type', '=', $this->type)
            ->when(false == $this->option('all'), function(Builder $builder) use ($hours){
                $builder->where('created_at', '<', now()->subHours($hours));
            })
            ->count();

        $this->info("К очистке $task_count задач");

        QueuedTask::where('type', '=', $this->type)
            ->when(false == $this->option('all'), function(Builder $builder) use ($hours){
                $builder->where('created_at', '<', now()->subHours($hours));
            })
            ->delete();

        $this->info("Очистка завершена");

        return self::SUCCESS;
    }
}