<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Astreya\WalletUtils\Dto\QueuedTaskData;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('queued_tasks', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->enum('type', QueuedTaskData::TYPES)->index();
            $table->enum('state', QueuedTaskData::STATES)->index();
            $table->json('context');
            $table->json('result');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('queued_tasks');
    }
};
