<?php

namespace Astreya\TaskSystem\Tests\Unit\Processors\Payment;

use Astreya\TaskSystem\Processors\Payment\AbstractPaymentProcessor;
use Astreya\TaskSystem\Processors\Payment\DummyPaymentProcessor;
use Astreya\TaskSystem\Tests\Unit\Processors\ProcessorTestCase;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use PHPUnit\Framework\TestCase;

class AbstractPaymentProcessorTest extends ProcessorTestCase
{
    protected function setUp(): void
    {
        parent::setUp();

        $this->task = $this->taskService->initCreatePaymentTask([
            'wallet'    => $this->buildWalletData()->toArray(),
            'payment'   => $this->buildPaymentData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);
    }

    public function testRun()
    {
        $sentryTransaction = $this->startSentryTransaction('process_task');

        $processor = new DummyPaymentProcessor($this->task);
        $processor->run();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $this->task->state);

        $tags = $sentryTransaction->getTags();

        $this->assertArrayHasKey('type', $tags);
        $this->assertArrayHasKey('wallet', $tags);
        $this->assertArrayHasKey('proxy', $tags);
    }
}
