<?php

namespace Astreya\TaskSystem\Tests\Feature\Jobs;

use Astreya\TaskSystem\Jobs\ProcessTaskJob;
use Astreya\TaskSystem\Services\TaskService;
use Astreya\TaskSystem\Tests\IntegrationTest;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Astreya\WalletUtils\Dto\WalletData;
use Error;


class ProcessTaskJobTest extends IntegrationTest
{
    const TASK_TYPE = QueuedTaskData::TYPE_FETCH_BALANCE;

    protected WalletData $walletData;

    protected TaskService $taskService;

    /**
     * @return void
     * @throws \Throwable
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->taskService = app()->get(TaskService::class);
    }

    /**
     * @return void
     * @throws \Throwable
     */
    public function test_it_should_execute_task(): void
    {
        $task = $this->taskService->initQueuedTask(self::TASK_TYPE, [
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);

        $job = new ProcessTaskJob($task);
        $job->handle();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $task->state);
    }

    /**
     * @return void
     * @throws \Throwable
     */
    public function test_it_should_process_exception(): void
    {
        $this->expectException(Error::class);
        config()->set('astreya-tasks.task_processors.' . self::TASK_TYPE, 'InvalidProcessor');

        $task = $this->taskService->initQueuedTask(self::TASK_TYPE, [
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url(),
        ]);

        $job = new ProcessTaskJob($task);
        $job->handle();

        $this->assertEquals(QueuedTaskData::STATE_FAILED, $task->state);
    }
}
