<?php


namespace Astreya\TaskSystem\Processors\Preparation;

use Astreya\TaskSystem\Processors\BaseTaskProcessor;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Sentry\State\Scope;
use function Sentry\withScope;

abstract class AbstractPreparationProcessor extends BaseTaskProcessor
{
    protected string $proxy;

    public function run(): void
    {
        $this->proxy = $this->currentTask->context['proxy'] ?? '';

        withScope(function(Scope $scope){
            if ($scope->getTransaction()) {
                $scope->getTransaction()->setTags([
                    'type'      => QueuedTaskData::TYPE_PREPARATION,
                    'wallet'    => $this->currentTask->getWalletData()->getLogin(),
                    'proxy'     => $this->proxy,
                ]);
            }
        });

        parent::run();

        withScope(function(Scope $scope){
            $scope->setContext('result', $this->currentTask->result);
        });
    }
}
