<?php

namespace Astreya\TaskSystem\Tests\Unit\Processors\FetchProfile;

use Astreya\TaskSystem\Processors\FetchProfile\DummyFetchProfileProcessor;
use Astreya\TaskSystem\Tests\Unit\Processors\ProcessorTestCase;
use Astreya\WalletUtils\Dto\QueuedTaskData;

class AbstractFetchProfileProcessorTest extends ProcessorTestCase
{
    protected function setUp(): void
    {
        parent::setUp();

        $this->task = $this->taskService->initFetchProfileTask([
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);
    }

    public function testRun()
    {
        $sentryTransaction = $this->startSentryTransaction('process_task');

        $processor = new DummyFetchProfileProcessor($this->task);
        $processor->run();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $this->task->state);

        $tags = $sentryTransaction->getTags();

        $this->assertArrayHasKey('type', $tags);
        $this->assertArrayHasKey('wallet', $tags);
        $this->assertArrayHasKey('proxy', $tags);
        $this->assertArrayHasKey('step', $tags);
    }
}
