<?php

namespace Astreya\TaskSystem\Http\Middleware;

use Astreya\TaskSystem\Models\QueuedTask;
use Closure;
use Illuminate\Http\Request;
use Sentry\State\Scope;
use function Sentry\withScope;

class SentryForTask
{
    protected ?QueuedTask $task = null;
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next): mixed
    {
        withScope(function (Scope $scope) use ($request) {
            $this->task = $request->route('queued_task');

            if ($this->task instanceof QueuedTask) {
                $scope->setTags([
                    'task_id'   => $this->task->id,
                    'type_type' => $this->task->type
                ]);
            }
        });

        return $next($request);
    }
}